<?php
// Add the menu and set required capability
add_action('admin_menu', 'asasi_menu');

function asasi_menu() {
    add_menu_page('ASA Server Info', 'ARK: SA', 'administrator', 'asasi', 'asasi_main_page', plugins_url( '/asa-server-info/images/ASA20.png' ));
    add_submenu_page(
        'asasi', // Parent page slug
        __('ASA Clusters', 'asa-server-info'), // Page title
        esc_html__('Clusters', 'asa-server-info'), // Menu title
        'administrator', // Required capability to access
        'asasi-clusters-page', // Page slug
        'asasi_clusters_page' // Callback to render the page
    );
    add_submenu_page(
        'asasi', // Parent page slug
        __('ASA Servers', 'asa-server-info'), // Page title
        esc_html__('Servers', 'asa-server-info'), // Menu title
        'administrator', // Required capability to access
        'asasi-servers-page', // Page slug
        'asasi_servers_page' // Callback to render the page
    );
}

function asasi_main_page() {
    ?>
    <div class="wrap">
        <h1><?php _e('ASA Server Info', 'asa-server-info'); ?></h1>
        <div class="card">
            <h2 class="title"><?php _e('ASA Server Info', 'asa-server-info'); ?></h2>
            <p><?php _e('Add information about your Ark Survival Ascended servers on your Wordpress page.', 'asa-server-info'); ?></p>
        </div>
    </div>
    <?php
}

function asasi_clusters_page() {
    global $wpdb; ?>
    <div class="wrap">
        <h2><?php _e('ASA Clusters Configuration', 'asa-server-info'); ?></h2>

        <!-- Add cluster button -->
        <a href="admin.php?page=asasi-add-cluster" class="button-primary"><?php esc_html_e('Add Cluster Ark SA', 'asa-server-info'); ?></a>
        
        <!-- Clusters table -->
        <?php
        // Query to get added clusters
        $clusters = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}asa_clusters");

        // Check if there are clusters
        if ($clusters) {
            // Show the table if clusters exist
            ?>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php _e('Cluster Number', 'asa-server-info'); ?></th>
                        <th><?php _e('Name', 'asa-server-info'); ?></th>
                        <th><?php _e('Exp. Multiplier', 'asa-server-info'); ?></th>
                        <th><?php _e('Taming Multiplier', 'asa-server-info'); ?></th>
                        <th><?php _e('Gathering Multiplier', 'asa-server-info'); ?></th>
                        <th><?php _e('Breeding Multiplier', 'asa-server-info'); ?></th>
                        <th><?php _e('Actions', 'asa-server-info'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    foreach ($clusters as $cluster) {
                        echo "<tr>";
                        echo "<td>{$cluster->ClusterNumber}</td>";
                        echo "<td>{$cluster->ClusterName}</td>";
                        echo "<td>{$cluster->ExpMulti}</td>";
                        echo "<td>{$cluster->TamingMulti}</td>";
                        echo "<td>{$cluster->GatheringMulti}</td>";
                        echo "<td>{$cluster->BreedingMulti}</td>";
                        echo "<td>";
                        echo "<a href='admin.php?page=asasi-edit-cluster&cluster_id={$cluster->ClusterNumber}' class='button'>" . esc_html__('Edit', 'asa-server-info') . "</a>";
                        echo "<a href='admin.php?page=asasi-delete-cluster&cluster_id={$cluster->ClusterNumber}' class='button'>" . esc_html__('Delete', 'asa-server-info') . "</a>";
                        echo "</td>";
                        echo "</tr>";
                    }
                    ?>
                </tbody>
            </table>
            <?php
        } else {
            // Show a message if no clusters exist
            echo "<p>" . _e('No clusters added yet.', 'asa-server-info') . "</p>";
        }
    ?>
    </div>
    <?php 
}
?>

<!-- Servers table -->
<?php
function asasi_servers_page() {
    global $wpdb; ?>
    <div class="wrap">
        <h2><?php _e('ASA Servers Configuration', 'asa-server-info'); ?></h2>
        
        <!-- Add server button -->
        <a href="admin.php?page=asasi-add-server" class="button-primary"><?php esc_html_e('Add Server Ark SA', 'asa-server-info'); ?></a>
        <?php 
            // Query to get added servers
            $servers = $wpdb->get_results("SELECT 
                s.ServerNumber, 
                s.ServerName, 
                IF(s.ClusterNumber = 0, '" . __('No cluster', 'asa-server-info') . "', c.ClusterName) AS ClusterName, 
                s.ServerBMid 
                FROM {$wpdb->prefix}asa_servers AS s 
                LEFT JOIN {$wpdb->prefix}asa_clusters AS c 
                ON s.ClusterNumber = c.ClusterNumber"
            );

            // Check if there are servers
            if ($servers) {
                // Show the table if servers exist
                ?>
                <table class="wp-list-table widefat fixed striped">
                    <thead>
                        <tr>
                            <th><?php _e('Server Number', 'asa-server-info'); ?></th>
                            <th><?php _e('Name', 'asa-server-info'); ?></th>
                            <th><?php _e('Cluster', 'asa-server-info'); ?></th>
                            <th><?php _e('BattleMetrics ID', 'asa-server-info'); ?></th>
                            <th><?php _e('Actions', 'asa-server-info'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($servers as $server) {
                            echo "<tr>";
                            echo "<td>{$server->ServerNumber}</td>";
                            echo "<td>{$server->ServerName}</td>";
                            echo "<td>{$server->ClusterName}</td>";
                            echo "<td>{$server->ServerBMid}</td>";
                            echo "<td>";
                            echo "<a href='admin.php?page=asasi-edit-server&server_id={$server->ServerNumber}' class='button'>" . esc_html__('Edit', 'asa-server-info') . "</a>";
                            echo "<a href='admin.php?page=asasi-delete-server&server_id={$server->ServerNumber}' class='button'>" . esc_html__('Delete', 'asa-server-info') . "</a>";
                            echo "</td>";
                            echo "</tr>";
                        }
                        ?>
                    </tbody>
                </table>
                <?php
            } else {
                // Show a message if no servers exist
                echo "<p>" . _e('No servers added yet.', 'asa-server-info') . "</p>";
            }
        ?>
    </div>
    <?php
}

add_action('admin_menu', 'asasi_add_cluster_menu');

function asasi_add_cluster_menu() {
    add_submenu_page(
        'asasi-clusters-page', // Parent page slug
        __('Add Cluster Ark SA', 'asa-server-info'), // Page title
        esc_html__('Add Cluster Ark SA', 'asa-server-info'), // Menu title
        'administrator', // Required capability to access
        'asasi-add-cluster', // Page slug
        'asasi_add_cluster' // Callback to render the page
    );
    add_submenu_page(
        'asasi-clusters-page', // Parent page slug
        __('Edit Cluster Ark SA', 'asa-server-info'), // Page title
        esc_html__('Edit Cluster Ark SA', 'asa-server-info'), // Menu title
        'administrator', // Required capability to access
        'asasi-edit-cluster', // Page slug
        'asasi_edit_cluster' // Callback to render the page
    );
    add_submenu_page(
        'asasi-clusters-page', // Parent page slug
        __('Delete Cluster Ark SA', 'asa-server-info'), // Page title
        esc_html__('Delete Cluster Ark SA', 'asa-server-info'), // Menu title
        'administrator', // Required capability to access
        'asasi-delete-cluster', // Page slug
        'asasi_delete_cluster' // Callback to render the page
    );
}

function asasi_add_cluster() {
    ?>
    <div class="wrap">
        <h2><?php _e('Add Cluster Ark SA', 'asa-server-info'); ?></h2>

        <form method="post" action="">
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="cluster_name"><?php _e('Cluster Name:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="text" id="cluster_name" name="cluster_name" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="experience_multiplier"><?php _e('Experience Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="experience_multiplier" name="experience_multiplier" min="0.01" step="0.01" value="1" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="taming_multiplier"><?php _e('Taming Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="taming_multiplier" name="taming_multiplier" min="0.01" step="0.01" value="1" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="gathering_multiplier"><?php _e('Gathering Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="gathering_multiplier" name="gathering_multiplier" min="0.01" step="0.01" value="1" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="breeding_multiplier"><?php _e('Breeding Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="breeding_multiplier" name="breeding_multiplier" min="0.01" step="0.01" value="1" required></td>
                    </tr>
                </tbody>
            </table>
            <input type="submit" name="submitAddCluster" id="submit" class="button button-primary" value="<?php esc_html_e('Add Cluster Ark SA', 'asa-server-info'); ?>">
        </form>
    </div>
    <?php
}

// Process the form when submitted
if (isset($_POST['submitAddCluster'])) {
    global $wpdb;

    // Validate all required fields are not empty
    if (empty($_POST['cluster_name'])) {
        echo '<div class="error"><p>' . esc_html__('Please enter a name for the cluster.', 'asa-server-info') . '</p></div>';
        return; // Stop form processing if any required field is missing
    }

    // Sanitize and get values from fields
    $cluster_name = sanitize_text_field($_POST['cluster_name']);
    $experience_multiplier = floatval($_POST['experience_multiplier']);
    $taming_multiplier = floatval($_POST['taming_multiplier']);
    $gathering_multiplier = floatval($_POST['gathering_multiplier']);
    $breeding_multiplier = floatval($_POST['breeding_multiplier']);

    // Insert new cluster into the database
    $wpdb->insert(
        "{$wpdb->prefix}asa_clusters",
        array(
            'ClusterName' => $cluster_name,
            'ExpMulti' => $experience_multiplier,
            'TamingMulti' => $taming_multiplier,
            'GatheringMulti' => $gathering_multiplier,
            'BreedingMulti' => $breeding_multiplier
        )
    );

    // Show success message and redirect to admin main menu
    echo '<div class="updated"><p>' . esc_html__('Cluster added successfully.', 'asa-server-info') . '</p></div>';
    echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-clusters-page">';
}

function asasi_edit_cluster() {
    // Check if a cluster ID is provided in the URL
    if (!isset($_GET['cluster_id'])) {
        echo '<div class="error"><p>' . esc_html__('No cluster ID provided.', 'asa-server-info') . '</p></div>';
        return;
    }

    global $wpdb;

    // Get cluster ID from URL and query to get cluster details
    $cluster_id = intval($_GET['cluster_id']);
    $cluster = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}asa_clusters WHERE ClusterNumber = %d", $cluster_id));

    // Check if cluster is found
    if (!$cluster && !isset($_POST['submitEditCluster'])) {
        echo '<div class="error"><p>' . esc_html__('No cluster found with the provided ID.', 'asa-server-info') . '</p></div>';
		echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-clusters-page">';
        return;
    }

    // Render the edit form
    ?>
    <div class="wrap">
        <h2><?php _e('Edit Cluster Ark SA', 'asa-server-info'); ?></h2>

        <?php if (!isset($_POST['submitEditCluster'])): ?>
        <form method="post" action="">
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="cluster_name"><?php _e('Cluster Name:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="text" id="cluster_name" name="cluster_name" value="<?php echo esc_attr($cluster->ClusterName); ?>" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="experience_multiplier"><?php _e('Experience Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="experience_multiplier" name="experience_multiplier" min="0.01" step="0.01" value="<?php echo esc_attr($cluster->ExpMulti); ?>" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="taming_multiplier"><?php _e('Taming Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="taming_multiplier" name="taming_multiplier" min="0.01" step="0.01" value="<?php echo esc_attr($cluster->TamingMulti); ?>" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="gathering_multiplier"><?php _e('Gathering Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="gathering_multiplier" name="gathering_multiplier" min="0.01" step="0.01" value="<?php echo esc_attr($cluster->GatheringMulti); ?>" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="breeding_multiplier"><?php _e('Breeding Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="breeding_multiplier" name="breeding_multiplier" min="0.01" step="0.01" value="<?php echo esc_attr($cluster->BreedingMulti); ?>" required></td>
                    </tr>
                </tbody>
            </table>
			<input type="hidden" id="cluster_number" name="cluster_number" value="<?php echo esc_attr($cluster->ClusterNumber); ?>" required>
            <input type="submit" name="submitEditCluster" id="submit" class="button button-primary" value="<?php esc_html_e('Edit Cluster Ark SA', 'asa-server-info'); ?>">
        </form>
		<?php endif; ?>
    </div>
    <?php
}

// Process the form when submitted
if (isset($_POST['submitEditCluster'])) {
    global $wpdb;

    // Validate that all required fields are not empty
    if (empty($_POST['cluster_name'])) {
        echo '<div class="error"><p>' . esc_html__('Please enter a name for the cluster.', 'asa-server-info') . '</p></div>';
        return; // Stop form processing if any required field is missing
    }

    // Sanitize and get values from the fields
    $cluster_number = intval($_POST['cluster_number']);
    $cluster_name = sanitize_text_field($_POST['cluster_name']);
    $experience_multiplier = floatval($_POST['experience_multiplier']);
    $taming_multiplier = floatval($_POST['taming_multiplier']);
    $gathering_multiplier = floatval($_POST['gathering_multiplier']);
    $breeding_multiplier = floatval($_POST['breeding_multiplier']);

    // Update the cluster in the database
    $wpdb->update(
        "{$wpdb->prefix}asa_clusters",
        array(
            'ClusterName' => $cluster_name,
            'ExpMulti' => $experience_multiplier,
            'TamingMulti' => $taming_multiplier,
            'GatheringMulti' => $gathering_multiplier,
            'BreedingMulti' => $breeding_multiplier
        ),
        array('ClusterNumber' => $cluster_number), // Where clause
        array(
            '%s', // ClusterName
            '%f', // ExpMulti
            '%f', // TamingMulti
            '%f', // GatheringMulti
            '%f' // BreedingMulti
        ),
        array('%d') // Where clause format
    );

    // Show success message and redirect to the admin main menu
    echo '<div class="updated"><p>' . esc_html__('Cluster edited successfully.', 'asa-server-info') . '</p></div>';
    echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-clusters-page">';
}

function asasi_delete_cluster() {
    // Check if delete confirmation has been submitted
    global $wpdb;
    if (isset($_POST['confirmDeleteCluster'])) {
        $cluster_id = intval($_GET['cluster_id']);

        if ($_POST['confirmDeleteCluster'] === esc_html__('Delete cluster Ark SA', 'asa-server-info')) {
            // Check if included servers in the cluster should be deleted
            $delete_included_servers = isset($_POST['deleteIncludedServers']) ? true : false;

            if ($delete_included_servers) {
                // Delete servers included in the cluster
                $wpdb->delete("{$wpdb->prefix}asa_servers", array('ClusterNumber' => $cluster_id));

                // Delete the cluster
                $wpdb->delete("{$wpdb->prefix}asa_clusters", array('ClusterNumber' => $cluster_id));
            } else {
                // Update servers included in the cluster
                $wpdb->update(
                    "{$wpdb->prefix}asa_servers",
                    array('ClusterNumber' => 0),
                    array('ClusterNumber' => $cluster_id),
                    array('%d'),
                    array('%d')
                );

                // Delete the cluster
                $wpdb->delete("{$wpdb->prefix}asa_clusters", array('ClusterNumber' => $cluster_id));
            }

            echo '<div class="updated"><p>' . esc_html__('Cluster deleted successfully.', 'asa-server-info') . '</p></div>';
            // Redirect somewhere after deleting the cluster
            echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-clusters-page">';
        }
    } else {
        if (isset($_GET['cluster_id'])) {
            $cluster_id = intval($_GET['cluster_id']);
            // Check if the cluster exists
            $existing_cluster = $wpdb->get_row($wpdb->prepare(
                "SELECT * FROM {$wpdb->prefix}asa_clusters WHERE ClusterNumber = %d",
                $cluster_id
            ));

            if ($existing_cluster) {
                // Show the confirmation box
                ?>
                <div class="wrap">
                    <h2><?php _e('Confirm Cluster Deletion', 'asa-server-info'); ?></h2>
                    <form method="post" action="">
                        <input type="hidden" name="cluster_id" value="<?php echo esc_attr($cluster_id); ?>">
                        <p><?php _e('Are you sure you want to delete this cluster?', 'asa-server-info'); ?></p>
                        <label>
                            <input type="checkbox" name="deleteIncludedServers" value="1">
                            <?php _e('Delete servers included in the cluster', 'asa-server-info'); ?>
                        </label>
                        <br><br>
                        <input type="submit" name="confirmDeleteCluster" class="button button-primary" value="<?php esc_html_e('Delete cluster Ark SA', 'asa-server-info'); ?>">
                        <a href="admin.php?page=asasi-clusters-page" class="button"><?php esc_html_e('Go back', 'asa-server-info'); ?></a>
                    </form>
                </div>
                <?php
            } else {
                // Show error if the cluster doesn't exist
                echo '<div class="error"><p>' . esc_html__('No cluster found with the provided ID.', 'asa-server-info') . '</p></div>';
                // Redirect after 2 seconds
                echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-clusters-page">';
            }
        } else {
            // Show error if no cluster ID is provided
            echo '<div class="error"><p>' . esc_html__('No cluster ID provided.', 'asa-server-info') . '</p></div>';
            // Redirect after 2 seconds
            echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-clusters-page">';
        }
    }
}

add_action('admin_menu', 'asasi_add_server_menu');

function asasi_add_server_menu() {
    add_submenu_page(
        'asasi-servers-page', // Parent page slug
        __('Add Server Ark SA', 'asa-server-info'), // Page title
        esc_html__('Add Server Ark SA', 'asa-server-info'), // Menu title
        'administrator', // Capability required to access
        'asasi-add-server', // Page slug
        'asasi_add_server' // Callback to render the page
    );
	add_submenu_page(
        'asasi-servers-page', // Parent page slug
        __('Edit Server Ark SA', 'asa-server-info'), // Page title
        esc_html__('Edit Server Ark SA', 'asa-server-info'), // Menu title
        'administrator', // Capability required to access
        'asasi-edit-server', // Page slug
        'asasi_edit_server' // Callback to render the page
    );
	add_submenu_page(
        'asasi-servers-page', // Parent page slug
        __('Delete Server Ark SA', 'asa-server-info'), // Page title
        esc_html__('Delete Server Ark SA', 'asa-server-info'), // Menu title
        'administrator', // Capability required to access
        'asasi-delete-server', // Page slug
        'asasi_delete_server' // Callback to render the page
    );
}

function asasi_add_server() {
    global $wpdb; ?>
    <div class="wrap">
        <h2><?php _e('Add Server Ark SA', 'asa-server-info'); ?></h2>

		<form method="post" action="">
            <table class="form-table">
                <tbody>
                    <tr>
                        <th scope="row"><label for="server_number"><?php _e('Server Number:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="server_number" name="server_number" min="1" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="server_name"><?php _e('Server Name:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="text" id="server_name" name="server_name" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="server_cluster"><?php _e('Server Cluster:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                        <td>
                            <select id="server_cluster" name="server_cluster" required>
                                <option value="0"><?php esc_html_e('No cluster', 'asa-server-info'); ?></option>
                                <?php
                                // Query to get existing clusters
                                $clusters = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}asa_clusters");

                                // Iterate over results to generate dropdown options
                                foreach ($clusters as $cluster) {
                                    echo "<option value='{$cluster->ClusterNumber}'>{$cluster->ClusterName}</option>";
                                }
                                ?>
                            </select>
                        </td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="battlemetrics_id"><?php _e('Battlemetrics ID:', 'asa-server-info'); ?>  <span style="color:#ff0000;">*</span></label></th>
                        <td><input type="number" id="battlemetrics_id" name="battlemetrics_id" min="1" required></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="rcon_port"><?php _e('RCON Port:', 'asa-server-info'); ?></label></th>
                        <td><input type="number" id="rcon_port" name="rcon_port" min="1"></td>
                    </tr>
                    <tr>
                        <th scope="row"><label for="rcon_password"><?php _e('RCON Password:', 'asa-server-info'); ?></label></th>
                        <td><input type="password" id="rcon_password" name="rcon_password"></td>
                    </tr>
                    <tr id="multiplier-options" style="display:hidden;">
                        <th scope="row"><?php _e('Server Settings:', 'asa-server-info'); ?></th>
                        <td>
                            <label for="experience_multiplier"><?php _e('Experience Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label>
                            <input type="number" id="experience_multiplier" name="experience_multiplier" min="0.01" step="0.01" value="1" required>
                            <br>
                            <label for="taming_multiplier"><?php _e('Taming Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label>
                            <input type="number" id="taming_multiplier" name="taming_multiplier" min="0.01" step="0.01" value="1" required>
                            <br>
                            <label for="gathering_multiplier"><?php _e('Gathering Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label>
                            <input type="number" id="gathering_multiplier" name="gathering_multiplier" min="0.01" step="0.01" value="1" required>
                            <br>
                            <label for="breeding_multiplier"><?php _e('Breeding Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label>
                            <input type="number" id="breeding_multiplier" name="breeding_multiplier" min="0.01" step="0.01" value="1" required>
                        </td>
                    </tr>
                </tbody>
            </table>
            <input type="submit" name="submitAddServer" id="submit" class="button button-primary" value="<?php esc_html_e('Add Server Ark SA', 'asa-server-info'); ?>">
        </form>
    </div>
    <?php
}

// Process the form when submitted
if (isset($_POST['submitAddServer'])) {
    global $wpdb;

    $server_number = intval($_POST['server_number']);
    $server_name = sanitize_text_field($_POST['server_name']);
    $server_cluster = sanitize_text_field($_POST['server_cluster']);
    $battlemetrics_id = intval($_POST['battlemetrics_id']);
    $rcon_port = isset($_POST['rcon_port']) ? intval($_POST['rcon_port']) : '';
    $rcon_password = isset($_POST['rcon_password']) ? sanitize_text_field($_POST['rcon_password']) : '';
    $experience_multiplier = isset($_POST['experience_multiplier']) ? floatval($_POST['experience_multiplier']) : 1.00;
    $taming_multiplier = isset($_POST['taming_multiplier']) ? floatval($_POST['taming_multiplier']) : 1.00;
    $gathering_multiplier = isset($_POST['gathering_multiplier']) ? floatval($_POST['gathering_multiplier']) : 1.00;
    $breeding_multiplier = isset($_POST['breeding_multiplier']) ? floatval($_POST['breeding_multiplier']) : 1.00;

    // Check if server number already exists
    $existing_server = $wpdb->get_row($wpdb->prepare(
        "SELECT * FROM {$wpdb->prefix}asa_servers WHERE ServerNumber = %d",
        $server_number
    ));

    if ($existing_server) {
        // If server number already exists, show error message and go back to form
        echo '<div class="error"><p>' . esc_html__('Server number already exists. Please choose another server number.', 'asa-server-info') . '</p></div>';
    } else {
        // If server number doesn't exist, insert the new server into the database
        $wpdb->insert(
            "{$wpdb->prefix}asa_servers",
            array(
                'ServerNumber' => $server_number,
                'ServerName' => $server_name,
                'ClusterNumber' => $server_cluster,
                'ServerBMid' => $battlemetrics_id,
                'ServerRCON' => $rcon_port,
                'ServerPassword' => $rcon_password,
                'ExpMulti' => $experience_multiplier,
                'TamingMulti' => $taming_multiplier,
                'GatheringMulti' => $gathering_multiplier,
                'BreedingMulti' => $breeding_multiplier
            )
        );

        // Show success message and redirect to the admin main menu
        echo '<div class="updated"><p>' . esc_html__('Server added successfully.', 'asa-server-info') . '</p></div>';
        echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-servers-page">';
    }
}

function asasi_edit_server() {
    // Check if server ID is provided in the URL
    if (!isset($_GET['server_id'])) {
        echo '<div class="error"><p>' . esc_html__('No server ID provided.', 'asa-server-info') . '</p></div>';
		echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-servers-page">';
        return;
    }
	
    global $wpdb;

    // Get server ID from URL and query to get its details
    $server_id = intval($_GET['server_id']);
    $server = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}asa_servers WHERE ServerNumber = %d", $server_id));

    // Check if server is found
    if (!$server and !isset($_POST['submitEditServer'])) {
        echo '<div class="error"><p>' . esc_html__('No server found with the provided ID.', 'asa-server-info') . '</p></div>';
		echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-servers-page">';
        return;
    }

    // Render the edit form
    ?>
<div class="wrap">
    <h2><?php _e('Edit Server Ark SA', 'asa-server-info'); ?></h2>

    <?php if (!isset($_POST['submitEditServer'])): ?>
    <form method="post" action="">
        <table class="form-table">
            <tbody>
                <tr>
                    <th scope="row"><label for="server_number"><?php _e('Server Number:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                    <td><input type="number" id="server_number" name="server_number" value="<?php echo esc_attr($server->ServerNumber); ?>" min="1" required></td>
                </tr>
                <tr>
                    <th scope="row"><label for="server_name"><?php _e('Server Name:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                    <td><input type="text" id="server_name" name="server_name" value="<?php echo esc_attr($server->ServerName); ?>" required></td>
                </tr>
                <tr>
                    <th scope="row"><label for="server_cluster"><?php _e('Server Cluster:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label></th>
                    <td>
                        <select id="server_cluster" name="server_cluster" required>
                            <option value="0"<?php if ($server->ClusterNumber == 0) {echo ' selected';} ?>><?php esc_html_e('No cluster', 'asa-server-info'); ?></option>
                            <?php
                            // Query to get existing clusters
                            $clusters = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}asa_clusters");

                            // Iterate over results to generate dropdown menu options
                            foreach ($clusters as $cluster) {
                                if ($server->ClusterNumber == $cluster->ClusterNumber) {
                                    echo "<option value='{$cluster->ClusterNumber}' selected>{$cluster->ClusterName}</option>";
                                } else {
                                    echo "<option value='{$cluster->ClusterNumber}'>{$cluster->ClusterName}</option>";
                                }
                            }
                            ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="battlemetrics_id"><?php _e('Battlemetrics ID:', 'asa-server-info'); ?>  <span style="color:#ff0000;">*</span></label></th>
                    <td><input type="number" id="battlemetrics_id" name="battlemetrics_id" value="<?php echo esc_attr($server->ServerBMid); ?>" min="1" required></td>
                </tr>
                <tr>
                    <th scope="row"><label for="rcon_port"><?php _e('RCON Port:', 'asa-server-info'); ?></label></th>
                    <td><input type="number" id="rcon_port" name="rcon_port" value="<?php echo esc_attr($server->ServerRCON); ?>" min="1"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="rcon_password"><?php _e('RCON Password:', 'asa-server-info'); ?></label></th>
                    <td><input type="password" id="rcon_password" name="rcon_password" value="<?php echo esc_attr($server->ServerPassword); ?>"></td>
                </tr>
                <tr id="multiplier-options"<?php if ($server->ClusterNumber <> 0) {echo ' style="display:none";';} ?>>
                    <th scope="row"><?php _e('Server Settings:', 'asa-server-info'); ?></th>
                    <td>
                        <label for="experience_multiplier"><?php _e('Experience Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label>
                        <input type="number" id="experience_multiplier" name="experience_multiplier" min="0.01" step="0.01" value="<?php echo esc_attr($server->ExpMulti); ?>" required>
                        <br>
                        <label for="taming_multiplier"><?php _e('Taming Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label>
                        <input type="number" id="taming_multiplier" name="taming_multiplier" min="0.01" step="0.01" value="<?php echo esc_attr($server->TamingMulti); ?>" required>
                        <br>
                        <label for="gathering_multiplier"><?php _e('Gathering Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label>
                        <input type="number" id="gathering_multiplier" name="gathering_multiplier" min="0.01" step="0.01" value="<?php echo esc_attr($server->GatheringMulti); ?>" required>
                        <br>
                        <label for="breeding_multiplier"><?php _e('Breeding Multiplier:', 'asa-server-info'); ?> <span style="color:#ff0000;">*</span></label>
                        <input type="number" id="breeding_multiplier" name="breeding_multiplier" min="0.01" step="0.01" value="<?php echo esc_attr($server->BreedingMulti); ?>" required>
                    </td>
                </tr>
            </tbody>
        </table>
		<input type="hidden" name="server_number_old" id="server_number_old" value="<?php echo $server_id; ?>">
        <input type="submit" name="submitEditServer" id="submit" class="button button-primary" value="<?php esc_html_e('Edit Server Ark SA', 'asa-server-info'); ?>">
    </form>
    <?php endif; ?>
</div>
<?php
}

// Process the form when submitted
if (isset($_POST['submitEditServer'])) {
    global $wpdb;

	$server_number_old = intval($_POST['server_number_old']);
    $server_number = intval($_POST['server_number']);
    $server_name = sanitize_text_field($_POST['server_name']);
    $server_cluster = sanitize_text_field($_POST['server_cluster']);
    $battlemetrics_id = intval($_POST['battlemetrics_id']);
    $rcon_port = isset($_POST['rcon_port']) ? intval($_POST['rcon_port']) : '';
    $rcon_password = isset($_POST['rcon_password']) ? sanitize_text_field($_POST['rcon_password']) : '';
    $experience_multiplier = isset($_POST['experience_multiplier']) ? floatval($_POST['experience_multiplier']) : 1.00;
    $taming_multiplier = isset($_POST['taming_multiplier']) ? floatval($_POST['taming_multiplier']) : 1.00;
    $gathering_multiplier = isset($_POST['gathering_multiplier']) ? floatval($_POST['gathering_multiplier']) : 1.00;
    $breeding_multiplier = isset($_POST['breeding_multiplier']) ? floatval($_POST['breeding_multiplier']) : 1.00;

    // Check if server number already exists and is different from the old one
	$existing_server = false;
	if ($server_number <> $server_number_old) {
		$check_existing_server = $wpdb->get_row($wpdb->prepare(
			"SELECT * FROM {$wpdb->prefix}asa_servers WHERE ServerNumber = %d",
			$server_number
		));
		if (!is_null($check_existing_server)) {
			$existing_server = true;
		}
	}

    if ($existing_server) {
        // If server number already exists, show error message and return to form
        echo '<div class="error"><p>' . esc_html__('Server number already exists. Please choose another server number.', 'asa-server-info') . '</p></div>';
    } else {
        // If server number doesn't exist or is the same as the current one, perform the update
        $wpdb->update(
            "{$wpdb->prefix}asa_servers",
            array(
                'ServerNumber' => $server_number,
                'ServerName' => $server_name,
                'ClusterNumber' => $server_cluster,
                'ServerBMid' => $battlemetrics_id,
                'ServerRCON' => $rcon_port,
                'ServerPassword' => $rcon_password,
                'ExpMulti' => $experience_multiplier,
                'TamingMulti' => $taming_multiplier,
                'GatheringMulti' => $gathering_multiplier,
                'BreedingMulti' => $breeding_multiplier
            ),
            array('ServerNumber' => $server_number_old), // Where clause
            array(
                '%d', // ServerNumber
                '%s', // ServerName
                '%s', // ClusterNumber
                '%d', // ServerBMid
                '%d', // ServerRCON
                '%s', // ServerPassword
                '%f', // ExpMulti
                '%f', // TamingMulti
                '%f', // GatheringMulti
                '%f' // BreedingMulti
            ),
            array('%d') // Where clause format
        );

        // Show success message and redirect to admin initial menu
        echo '<div class="updated"><p>' . esc_html__('Server edited successfully.', 'asa-server-info') . '</p></div>';
        echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-servers-page">';
    }
}

function asasi_delete_server() {
    // Check if delete confirmation is submitted
    global $wpdb;
    if (isset($_POST['confirmDeleteServer'])) {
        $server_id = intval($_GET['server_id']);

        if ($_POST['confirmDeleteServer'] === esc_html__('Delete Server Ark SA', 'asa-server-info')) {
            // Delete server from database
            $wpdb->delete("{$wpdb->prefix}asa_servers", array('ServerNumber' => $server_id));

            echo '<div class="updated"><p>' . esc_html__('Server deleted successfully.', 'asa-server-info') . '</p></div>';
            // Redirect after deleting the server
            echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-servers-page">';
        }
    } else {
        if (isset($_GET['server_id'])) {
            $server_id = intval($_GET['server_id']);
            // Check if server exists
            $existing_server = $wpdb->get_row($wpdb->prepare(
                "SELECT * FROM {$wpdb->prefix}asa_servers WHERE ServerNumber = %d",
                $server_id
            ));

            if ($existing_server) {
                // Show confirmation box
                ?>
                <div class="wrap">
                    <h2><?php _e('Confirm Server Deletion', 'asa-server-info'); ?></h2>
                    <form method="post" action="">
                        <p><?php _e('Are you sure you want to delete this server?', 'asa-server-info'); ?></p>
                        <input type="submit" name="confirmDeleteServer" class="button button-primary" value="<?php esc_html_e('Delete Server Ark SA', 'asa-server-info'); ?>">
                        <a href="admin.php?page=asasi-servers-page" class="button"><?php esc_html_e('Go back', 'asa-server-info'); ?></a>
                    </form>
                </div>
                <?php
            } else {
                // Show error if server doesn't exist
                echo '<div class="error"><p>' . esc_html__('No server found with provided ID.', 'asa-server-info') . '</p></div>';
                // Redirect after 2 seconds
                echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-servers-page">';
            }
        } else {
            // Show error if no server ID provided
            echo '<div class="error"><p>' . esc_html__('No server ID provided.', 'asa-server-info') . '</p></div>';
            // Redirect after 2 seconds
            echo '<meta http-equiv="refresh" content="2;url=admin.php?page=asasi-servers-page">';
        }
    }
}

// Script to show or hide multiplier options based on cluster selection
function asa_show_hide_multiplier_options_script() {
    ?>
    <script>
        jQuery(document).ready(function($) {
            $('#server_cluster').change(function() {
                if ($(this).val() === '0') {
                    $('#multiplier-options').show();
                } else {
                    $('#multiplier-options').hide();
                }
            });
        });
    </script>
    <?php
}

add_action('admin_footer', 'asa_show_hide_multiplier_options_script');

?>